/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.onyxstudios.cca.api.v3.block.BlockComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.block.BlockComponentInitializer;
import dev.onyxstudios.cca.api.v3.chunk.ChunkComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.chunk.ChunkComponentInitializer;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.api.v3.world.WorldComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.world.WorldComponentInitializer;
import fuzs.puzzleslib.capability.CapabilityController;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.CapabilityFactory;
import fuzs.puzzleslib.capability.data.CapabilityKey;
import fuzs.puzzleslib.capability.data.ComponentHolder;
import fuzs.puzzleslib.capability.data.FabricCapabilityKey;
import fuzs.puzzleslib.capability.data.FabricPlayerCapabilityKey;
import fuzs.puzzleslib.capability.data.PlayerCapabilityKey;
import fuzs.puzzleslib.capability.data.PlayerRespawnStrategy;
import fuzs.puzzleslib.capability.data.SyncStrategy;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;

public class FabricCapabilityController
implements CapabilityController,
EntityComponentInitializer,
BlockComponentInitializer,
ChunkComponentInitializer,
WorldComponentInitializer {
    private static final Map<String, FabricCapabilityController> MOD_TO_CAPABILITIES = Maps.newConcurrentMap();
    private static final Map<PlayerRespawnStrategy, RespawnCopyStrategy<Component>> STRATEGY_CONVERTER_MAP = ImmutableMap.builder().put((Object)PlayerRespawnStrategy.ALWAYS_COPY, (Object)RespawnCopyStrategy.ALWAYS_COPY).put((Object)PlayerRespawnStrategy.INVENTORY, (Object)RespawnCopyStrategy.INVENTORY).put((Object)PlayerRespawnStrategy.LOSSLESS, (Object)RespawnCopyStrategy.LOSSLESS_ONLY).put((Object)PlayerRespawnStrategy.NEVER, (Object)RespawnCopyStrategy.NEVER_COPY).build();
    private final String namespace;
    private final Multimap<Class<?>, Consumer<Object>> providerClazzToRegistration = ArrayListMultimap.create();

    private FabricCapabilityController(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    public FabricCapabilityController() {
        this("_internal");
    }

    @Override
    public <C extends CapabilityComponent> CapabilityKey<C> registerItemCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Predicate<class_1792> itemFilter) {
        throw new RuntimeException("Registering item stack capabilities is currently not supported on Fabric, use ItemStack#tag to attach additional data");
    }

    @Override
    public <T extends class_1297, C extends CapabilityComponent> CapabilityKey<C> registerEntityCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof EntityComponentFactoryRegistry) {
                EntityComponentFactoryRegistry registry = (EntityComponentFactoryRegistry)o;
                registry.registerFor(entityType, componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.createComponent(o1)));
            }
        });
    }

    @Override
    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, PlayerRespawnStrategy respawnStrategy) {
        return this.registerCapability(class_1297.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof EntityComponentFactoryRegistry) {
                EntityComponentFactoryRegistry registry = (EntityComponentFactoryRegistry)o;
                registry.registerForPlayers(componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.createComponent(o1)), STRATEGY_CONVERTER_MAP.get(respawnStrategy));
            }
        }, FabricPlayerCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, PlayerRespawnStrategy respawnStrategy, SyncStrategy syncStrategy) {
        return ((FabricPlayerCapabilityKey)this.registerPlayerCapability(capabilityKey, capabilityType, capabilityFactory, respawnStrategy)).setSyncStrategy(syncStrategy);
    }

    @Override
    public <T extends class_2586, C extends CapabilityComponent> CapabilityKey<C> registerBlockEntityCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Class<T> blockEntityType) {
        return this.registerCapability(class_2586.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof BlockComponentFactoryRegistry) {
                BlockComponentFactoryRegistry registry = (BlockComponentFactoryRegistry)o;
                registry.registerFor(blockEntityType, componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.createComponent(o1)));
            }
        });
    }

    @Override
    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelChunkCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory) {
        return this.registerCapability(class_2818.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof ChunkComponentFactoryRegistry) {
                ChunkComponentFactoryRegistry registry = (ChunkComponentFactoryRegistry)o;
                registry.register(componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.createComponent(o1)));
            }
        });
    }

    @Override
    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory) {
        return this.registerCapability(class_1937.class, capabilityKey, capabilityType, componentKey -> o -> {
            if (o instanceof WorldComponentFactoryRegistry) {
                WorldComponentFactoryRegistry registry = (WorldComponentFactoryRegistry)o;
                registry.register(componentKey, o1 -> new ComponentHolder((CapabilityComponent)capabilityFactory.createComponent(o1)));
            }
        });
    }

    private <C extends CapabilityComponent> CapabilityKey<C> registerCapability(Class<?> objectType, String capabilityKey, Class<C> capabilityType, Function<ComponentKey<ComponentHolder>, Consumer<Object>> factoryRegistration) {
        return this.registerCapability(objectType, capabilityKey, capabilityType, factoryRegistration, FabricCapabilityKey::new);
    }

    private <C extends CapabilityComponent, T extends CapabilityKey<C>> T registerCapability(Class<?> objectType, String capabilityKey, Class<C> capabilityType, Function<ComponentKey<ComponentHolder>, Consumer<Object>> factoryRegistration, FabricCapabilityKey.FabricCapabilityKeyFactory<C, T> capabilityKeyFactory) {
        ComponentKey componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(new class_2960(this.namespace, capabilityKey), ComponentHolder.class);
        this.providerClazzToRegistration.put(objectType, factoryRegistration.apply((ComponentKey<ComponentHolder>)componentKey));
        return capabilityKeyFactory.apply((ComponentKey<ComponentHolder>)componentKey, capabilityType);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        FabricCapabilityController.registerComponentFactories(class_1297.class, registry);
    }

    public void registerBlockComponentFactories(BlockComponentFactoryRegistry registry) {
        FabricCapabilityController.registerComponentFactories(class_2586.class, registry);
    }

    public void registerChunkComponentFactories(ChunkComponentFactoryRegistry registry) {
        FabricCapabilityController.registerComponentFactories(class_2818.class, registry);
    }

    public void registerWorldComponentFactories(WorldComponentFactoryRegistry registry) {
        FabricCapabilityController.registerComponentFactories(class_1937.class, registry);
    }

    private static <T> void registerComponentFactories(Class<?> baseType, T registry) {
        for (FabricCapabilityController controller : MOD_TO_CAPABILITIES.values()) {
            for (Consumer factoryRegistration : controller.providerClazzToRegistration.get(baseType)) {
                factoryRegistration.accept(registry);
            }
        }
    }

    public static synchronized CapabilityController of(String namespace) {
        return MOD_TO_CAPABILITIES.computeIfAbsent(namespace, key -> {
            FabricCapabilityController controller = new FabricCapabilityController(namespace);
            PuzzlesLib.LOGGER.info("Creating capability controller for mod id {}", (Object)namespace);
            return controller;
        });
    }
}

